﻿#region Copyright ©2011-2012, SIVECO Romania SA - All Rights Reserved
// ======================================================================
// Copyright ©2011-2012, SIVECO Romania SA - All Rights Reserved
// ======================================================================
// This file and its contents are protected by Romanian and International
// copyright laws. Unauthorized reproduction and/or distribution of all
// or any portion of the code contained herein is strictly prohibited
// and will result in severe civil and criminal penalties.
// Any violations of this copyright will be prosecuted
// to the fullest extent possible under law.
// ======================================================================
// THIS COPYRIGHT NOTICE MAY NOT BE REMOVED FROM THIS FILE.
// ======================================================================
#endregion

#region References
using System;
using System.Linq;
#endregion

namespace Cnas.Siui.BarCode
{
    public static class ExtensionMethods
    {
        /// <summary>
        /// Extension to check if the given string contains any of the tokens
        /// </summary>
        /// <param name="str">String to search in</param>
        /// <param name="values">String tokens to search for</param>
        /// <returns></returns>
        public static bool ContainsAny( this string str, params string[] values )
        {
            return ( String.IsNullOrEmpty( str ) == false || values.Length > 0 ) &&
                   values.Any( value => str != null && str.Contains( value ) );
        }
    }
}